//---------------------------------------------------------------------------
#ifndef EnvironmentH
#define EnvironmentH
//---------------------------------------------------------------------------
#include "common.h"
#include "CommControl_Form.h"

#define MAX_COMM_COUNT  10

#define SYSTEM_INFO_LCID_KR 1042
#define SYSTEM_INFO_LCID_CH 2052
#define SYSTEM_INFO_LCID_EN 1033
#define SYSTEM_INFO_LCID_JP 1041

#define SYSTEM_INFO_COMM_TYPE_USB     1
#define SYSTEM_INFO_COMM_TYPE_HYBRID  2
#define SYSTEM_INFO_COMM_TYPE_TCP_IP  3

#define SYSTEM_INFO_MACHINE_TYPE_150T 0
#define SYSTEM_INFO_MACHINE_TYPE_150H 1
#define SYSTEM_INFO_MACHINE_TYPE_200T 2
#define SYSTEM_INFO_MACHINE_TYPE_200H 3

#define SYSTEM_INFO_DEFAULT_BRD_COUNT 6

#define TPB_NONE			0
#define TPB_OPERATION		1

typedef struct{
  unsigned short TcpPort;
  char IpAddress[32];
}TCommParameter;

typedef struct{
  AnsiString Root;
  AnsiString Tablet;
  AnsiString Capsule;
  AnsiString Env_Root;
}TProgramPath;

typedef struct{
  int SelectedLCID;
  int SelectedCommType;
  int MachineType;
  int comm_brdCount;
  int LaserComplexer;
  int CommCheckSW;
  int noLicenseApplication;
  WideString tmsAppName;
  WideString cmsAppName;
  AnsiString sLaserPath;
  int TPB_OperationMode;
}TApplicationStartOption;

extern TApplicationStartOption ApplicationStartOption;
extern TCommParameter CommParameter[MAX_COMM_COUNT];//[Comm Index]
extern TProgramPath ProgramPath;

void __fastcall Environment_Init(void);
void __fastcall Environment_Destroy(void);
void __fastcall ReadCommunicationParams(AnsiString fileName);
void __fastcall WriteDefaultCommunicationParams(AnsiString fileName);
void __fastcall ReadApplicationOption(AnsiString fileName, TApplicationStartOption *pApplicationStartOption);
void __fastcall WriteApplicationOption(AnsiString fileName, TApplicationStartOption *pApplicationStartOption);
void __fastcall TPB_WriteApplicationOption(AnsiString fileName, TApplicationStartOption *pApplicationStartOption);

#endif
